package user_interface;

import complex_operations.*;
import db_context.DbContext;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class MenuOther extends Menu {
    @Override
    public void print() {
        System.out.println("********************************");
        System.out.println("* 1. show stats                *");
        System.out.println("* 2. simulate delivery         *");
        System.out.println("* 3. find driver for package   *");
        System.out.println("* 4. pay rise                  *");
        System.out.println("* 5. refund                    *");
        System.out.println("* 6. back to main menu         *");
        System.out.println("********************************");
    }

    @Override
    public void handle(String option) {
        try {
            switch (option) {
                case "1":  stats(); break;
                case "2":  simulation(); break;
                case "3":  FreeDriver.getInstance().FindFreeDriver(); break;
                case "4":  PayRise.getInstance().RiseDriverSalaries(); break;
                case "5":  Refund.getInstance().DoRefund(); break;
                case "6":  exit(); break;
                default:   System.out.println("Unknown option"); break;
            }
        } catch(Exception e) {
            //throw new RuntimeException(e);
            if(e.getClass().toString().equals("class java.lang.NumberFormatException")) System.out.println("Wrong input");
            else System.out.println("something went wrong\nmessage: " + e.getMessage());
        }
    }

    private void stats() throws Exception{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("* 1. package stats           *");
        System.out.println("* 2. locations stats         *");

        switch (br.readLine()){
            case "1": Statistics.getInstance().PackageStats(); return;
            case "2": Statistics.getInstance().LocationsStats(); break;
        }
    }

    private void simulation() throws Exception{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter transport id");
        Simulation.getInstance().SimulateTransport(Integer.parseInt(br.readLine()), false);
    }
}
